

                        
      
package io.fabric8.knative.client.eventing.v1alpha1.internal;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.knative.eventing.contrib.couchdb.v1alpha1.CouchDbSource;
import io.fabric8.knative.eventing.contrib.couchdb.v1alpha1.CouchDbSourceList;

import java.util.Map;
import java.util.TreeMap;


public class CouchDbSourceOperationsImpl extends HasMetadataOperation<CouchDbSource, CouchDbSourceList, Resource<CouchDbSource>> {

  public CouchDbSourceOperationsImpl(OkHttpClient client, Config config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public CouchDbSourceOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("sources.knative.dev")
    .withApiGroupVersion("v1alpha1")
    .withPlural("couchdbsources"));
    this.type = CouchDbSource.class;
    this.listType = CouchDbSourceList.class;
  }

  public CouchDbSourceOperationsImpl newInstance(OperationContext context) {
    return new CouchDbSourceOperationsImpl(context);
  }

  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
