

                        
      
package io.fabric8.knative.client.eventing.v1beta1.internal;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaChannel;
import io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaChannelList;

import java.util.Map;
import java.util.TreeMap;


public class KafkaChannelOperationsImpl extends HasMetadataOperation<KafkaChannel, KafkaChannelList, Resource<KafkaChannel>> {

  public KafkaChannelOperationsImpl(OkHttpClient client, Config config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public KafkaChannelOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("messaging.knative.dev")
    .withApiGroupVersion("v1beta1")
    .withPlural("kafkachannels"));
    this.type = KafkaChannel.class;
    this.listType = KafkaChannelList.class;
  }

  public KafkaChannelOperationsImpl newInstance(OperationContext context) {
    return new KafkaChannelOperationsImpl(context);
  }

  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
