

                        
      
package io.fabric8.knative.client.messaging.v1.internal;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.knative.messaging.v1.InMemoryChannel;
import io.fabric8.knative.messaging.v1.InMemoryChannelList;

import java.util.Map;
import java.util.TreeMap;


public class InMemoryChannelOperationsImpl extends HasMetadataOperation<InMemoryChannel, InMemoryChannelList, Resource<InMemoryChannel>> {

  public InMemoryChannelOperationsImpl(OkHttpClient client, Config config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public InMemoryChannelOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("messaging.knative.dev")
    .withApiGroupVersion("v1")
    .withPlural("inmemorychannels"));
    this.type = InMemoryChannel.class;
    this.listType = InMemoryChannelList.class;
  }

  public InMemoryChannelOperationsImpl newInstance(OperationContext context) {
    return new InMemoryChannelOperationsImpl(context);
  }

  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
