

                        
      
package io.fabric8.knative.client.sources.v1beta1.internal;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.knative.sources.v1beta1.SinkBinding;
import io.fabric8.knative.sources.v1beta1.SinkBindingList;

import java.util.Map;
import java.util.TreeMap;


public class SinkBindingOperationsImpl extends HasMetadataOperation<SinkBinding, SinkBindingList, Resource<SinkBinding>> {

  public SinkBindingOperationsImpl(OkHttpClient client, Config config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public SinkBindingOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("sources.knative.dev")
    .withApiGroupVersion("v1beta1")
    .withPlural("sinkbindings"));
    this.type = SinkBinding.class;
    this.listType = SinkBindingList.class;
  }

  public SinkBindingOperationsImpl newInstance(OperationContext context) {
    return new SinkBindingOperationsImpl(context);
  }

  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
