

                        

package io.fabric8.knative.client.eventing.v1beta1.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.knative.client.eventing.v1beta1.internal.KafkaBindingOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaBinding;
import io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaBindingBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class KafkaBindingHandler implements ResourceHandler<KafkaBinding, KafkaBindingBuilder> {

  @Override
  public String getKind() {
    return KafkaBinding.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "bindings.knative.dev/v1beta1";
      }

  @Override
  public KafkaBinding create(OkHttpClient client, Config config, String namespace, KafkaBinding item) {
    return new KafkaBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).create();
  }

  @Override
  public KafkaBinding replace(OkHttpClient client, Config config, String namespace, KafkaBinding item) {
    return new KafkaBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
  }

  @Override
  public KafkaBinding reload(OkHttpClient client, Config config, String namespace, KafkaBinding item) {
    return new KafkaBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public KafkaBindingBuilder edit(KafkaBinding item) {
    return new KafkaBindingBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, KafkaBinding item) {
    return new KafkaBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).withPropagationPolicy(propagationPolicy).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, KafkaBinding item, Watcher<KafkaBinding> watcher) {
    return new KafkaBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, KafkaBinding item, String resourceVersion, Watcher<KafkaBinding> watcher) {
    return new KafkaBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, KafkaBinding item, ListOptions listOptions, Watcher<KafkaBinding> watcher) {
    return new KafkaBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(listOptions, watcher);
  }

  @Override
  public KafkaBinding waitUntilReady(OkHttpClient client, Config config, String namespace, KafkaBinding item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new KafkaBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public KafkaBinding waitUntilCondition(OkHttpClient client, Config config, String namespace, KafkaBinding item, Predicate<KafkaBinding> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new KafkaBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
