

                        
      
package io.fabric8.knative.client.serving.v1beta1.internal;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.knative.serving.v1beta1.Revision;
import io.fabric8.knative.serving.v1beta1.RevisionBuilder;
import io.fabric8.knative.serving.v1beta1.RevisionList;

import java.util.Map;
import java.util.TreeMap;


public class RevisionOperationsImpl extends HasMetadataOperation<Revision, RevisionList, Resource<Revision>> {

  public RevisionOperationsImpl(OkHttpClient client, Config config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public RevisionOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("serving.knative.dev")
    .withApiGroupVersion("v1beta1")
    .withPlural("revisions"));
    this.type = Revision.class;
    this.listType = RevisionList.class;
  }

  public RevisionOperationsImpl newInstance(OperationContext context) {
    return new RevisionOperationsImpl(context);
  }

  @Override
  public Revision edit(Visitor... visitors) {
    return patch(new RevisionBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
