

                        
      
package io.fabric8.knative.client.eventing.v1alpha1.internal;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.knative.eventing.contrib.github.v1alpha1.GitHubSource;
import io.fabric8.knative.eventing.contrib.github.v1alpha1.GitHubSourceBuilder;
import io.fabric8.knative.eventing.contrib.github.v1alpha1.GitHubSourceList;

import java.util.Map;
import java.util.TreeMap;


public class GitHubSourceOperationsImpl extends HasMetadataOperation<GitHubSource, GitHubSourceList, Resource<GitHubSource>> {

  public GitHubSourceOperationsImpl(OkHttpClient client, Config config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public GitHubSourceOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("sources.knative.dev")
    .withApiGroupVersion("v1alpha1")
    .withPlural("githubsources"));
    this.type = GitHubSource.class;
    this.listType = GitHubSourceList.class;
  }

  public GitHubSourceOperationsImpl newInstance(OperationContext context) {
    return new GitHubSourceOperationsImpl(context);
  }

  @Override
  public GitHubSource edit(Visitor... visitors) {
    return patch(new GitHubSourceBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
