

                        

package io.fabric8.knative.client.eventing.v1alpha1.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.knative.client.eventing.v1alpha1.internal.GitLabSourceOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.knative.eventing.contrib.gitlab.v1alpha1.GitLabSource;
import io.fabric8.knative.eventing.contrib.gitlab.v1alpha1.GitLabSourceBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class GitLabSourceHandler implements ResourceHandler<GitLabSource, GitLabSourceBuilder> {

  @Override
  public String getKind() {
    return GitLabSource.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "sources.knative.dev/v1alpha1";
      }

  @Override
  public GitLabSource create(OkHttpClient client, Config config, String namespace, GitLabSource item) {
    return new GitLabSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).create();
  }

  @Override
  public GitLabSource replace(OkHttpClient client, Config config, String namespace, GitLabSource item) {
    return new GitLabSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
  }

  @Override
  public GitLabSource reload(OkHttpClient client, Config config, String namespace, GitLabSource item) {
    return new GitLabSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public GitLabSourceBuilder edit(GitLabSource item) {
    return new GitLabSourceBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, GitLabSource item) {
    return new GitLabSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).withPropagationPolicy(propagationPolicy).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, GitLabSource item, Watcher<GitLabSource> watcher) {
    return new GitLabSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, GitLabSource item, String resourceVersion, Watcher<GitLabSource> watcher) {
    return new GitLabSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, GitLabSource item, ListOptions listOptions, Watcher<GitLabSource> watcher) {
    return new GitLabSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(listOptions, watcher);
  }

  @Override
  public GitLabSource waitUntilReady(OkHttpClient client, Config config, String namespace, GitLabSource item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new GitLabSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public GitLabSource waitUntilCondition(OkHttpClient client, Config config, String namespace, GitLabSource item, Predicate<GitLabSource> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new GitLabSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
