

                        

package io.fabric8.knative.client.eventing.v1beta1.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.knative.client.eventing.v1beta1.internal.KafkaChannelOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaChannel;
import io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaChannelBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class KafkaChannelHandler implements ResourceHandler<KafkaChannel, KafkaChannelBuilder> {

  @Override
  public String getKind() {
    return KafkaChannel.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "messaging.knative.dev/v1beta1";
      }

  @Override
  public KafkaChannel create(OkHttpClient client, Config config, String namespace, KafkaChannel item) {
    return new KafkaChannelOperationsImpl(client, config).withItem(item).inNamespace(namespace).create();
  }

  @Override
  public KafkaChannel replace(OkHttpClient client, Config config, String namespace, KafkaChannel item) {
    return new KafkaChannelOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
  }

  @Override
  public KafkaChannel reload(OkHttpClient client, Config config, String namespace, KafkaChannel item) {
    return new KafkaChannelOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public KafkaChannelBuilder edit(KafkaChannel item) {
    return new KafkaChannelBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, KafkaChannel item) {
    return new KafkaChannelOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).withPropagationPolicy(propagationPolicy).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, KafkaChannel item, Watcher<KafkaChannel> watcher) {
    return new KafkaChannelOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, KafkaChannel item, String resourceVersion, Watcher<KafkaChannel> watcher) {
    return new KafkaChannelOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, KafkaChannel item, ListOptions listOptions, Watcher<KafkaChannel> watcher) {
    return new KafkaChannelOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(listOptions, watcher);
  }

  @Override
  public KafkaChannel waitUntilReady(OkHttpClient client, Config config, String namespace, KafkaChannel item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new KafkaChannelOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public KafkaChannel waitUntilCondition(OkHttpClient client, Config config, String namespace, KafkaChannel item, Predicate<KafkaChannel> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new KafkaChannelOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
