

                        
      
package io.fabric8.knative.client.eventing.v1beta1.internal;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaBinding;
import io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaBindingBuilder;
import io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaBindingList;

import java.util.Map;
import java.util.TreeMap;


public class KafkaBindingOperationsImpl extends HasMetadataOperation<KafkaBinding, KafkaBindingList, Resource<KafkaBinding>> {

  public KafkaBindingOperationsImpl(OkHttpClient client, Config config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public KafkaBindingOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("bindings.knative.dev")
    .withApiGroupVersion("v1beta1")
    .withPlural("kafkabindings"));
    this.type = KafkaBinding.class;
    this.listType = KafkaBindingList.class;
  }

  public KafkaBindingOperationsImpl newInstance(OperationContext context) {
    return new KafkaBindingOperationsImpl(context);
  }

  @Override
  public KafkaBinding edit(Visitor... visitors) {
    return patch(new KafkaBindingBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
