

                        

package io.fabric8.knative.client.sources.v1beta1.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.knative.client.sources.v1beta1.internal.SinkBindingOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.knative.sources.v1beta1.SinkBinding;
import io.fabric8.knative.sources.v1beta1.SinkBindingBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class SinkBindingHandler implements ResourceHandler<SinkBinding, SinkBindingBuilder> {

  @Override
  public String getKind() {
    return SinkBinding.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "sources.knative.dev/v1beta1";
      }

  @Override
  public SinkBinding create(OkHttpClient client, Config config, String namespace, SinkBinding item, boolean dryRun) {
    return new SinkBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public SinkBinding replace(OkHttpClient client, Config config, String namespace, SinkBinding item, boolean dryRun) {
    return new SinkBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public SinkBinding reload(OkHttpClient client, Config config, String namespace, SinkBinding item) {
    return new SinkBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public SinkBindingBuilder edit(SinkBinding item) {
    return new SinkBindingBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, SinkBinding item, boolean dryRun) {
    return new SinkBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, SinkBinding item, Watcher<SinkBinding> watcher) {
    return new SinkBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, SinkBinding item, String resourceVersion, Watcher<SinkBinding> watcher) {
    return new SinkBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, SinkBinding item, ListOptions listOptions, Watcher<SinkBinding> watcher) {
    return new SinkBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(listOptions, watcher);
  }

  @Override
  public SinkBinding waitUntilReady(OkHttpClient client, Config config, String namespace, SinkBinding item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new SinkBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public SinkBinding waitUntilCondition(OkHttpClient client, Config config, String namespace, SinkBinding item, Predicate<SinkBinding> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new SinkBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
