

                        

package io.fabric8.knative.client.eventing.v1alpha1.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.knative.client.eventing.v1alpha1.internal.AwsSqsSourceOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.knative.eventing.contrib.awssqs.v1alpha1.AwsSqsSource;
import io.fabric8.knative.eventing.contrib.awssqs.v1alpha1.AwsSqsSourceBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class AwsSqsSourceHandler implements ResourceHandler<AwsSqsSource, AwsSqsSourceBuilder> {

  @Override
  public String getKind() {
    return AwsSqsSource.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "sources.knative.dev/v1alpha1";
      }

  @Override
  public AwsSqsSource create(OkHttpClient client, Config config, String namespace, AwsSqsSource item, boolean dryRun) {
    return new AwsSqsSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public AwsSqsSource replace(OkHttpClient client, Config config, String namespace, AwsSqsSource item, boolean dryRun) {
    return new AwsSqsSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public AwsSqsSource reload(OkHttpClient client, Config config, String namespace, AwsSqsSource item) {
    return new AwsSqsSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public AwsSqsSourceBuilder edit(AwsSqsSource item) {
    return new AwsSqsSourceBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, AwsSqsSource item, boolean dryRun) {
    return new AwsSqsSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, AwsSqsSource item, Watcher<AwsSqsSource> watcher) {
    return new AwsSqsSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, AwsSqsSource item, String resourceVersion, Watcher<AwsSqsSource> watcher) {
    return new AwsSqsSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, AwsSqsSource item, ListOptions listOptions, Watcher<AwsSqsSource> watcher) {
    return new AwsSqsSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(listOptions, watcher);
  }

  @Override
  public AwsSqsSource waitUntilReady(OkHttpClient client, Config config, String namespace, AwsSqsSource item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new AwsSqsSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public AwsSqsSource waitUntilCondition(OkHttpClient client, Config config, String namespace, AwsSqsSource item, Predicate<AwsSqsSource> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new AwsSqsSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
