

                        

package io.fabric8.knative.client.eventing.v1alpha1.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.knative.client.eventing.v1alpha1.internal.CouchDbSourceOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.knative.eventing.contrib.couchdb.v1alpha1.CouchDbSource;
import io.fabric8.knative.eventing.contrib.couchdb.v1alpha1.CouchDbSourceBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class CouchDbSourceHandler implements ResourceHandler<CouchDbSource, CouchDbSourceBuilder> {

  @Override
  public String getKind() {
    return CouchDbSource.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "sources.knative.dev/v1alpha1";
      }

  @Override
  public CouchDbSource create(OkHttpClient client, Config config, String namespace, CouchDbSource item, boolean dryRun) {
    return new CouchDbSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public CouchDbSource replace(OkHttpClient client, Config config, String namespace, CouchDbSource item, boolean dryRun) {
    return new CouchDbSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public CouchDbSource reload(OkHttpClient client, Config config, String namespace, CouchDbSource item) {
    return new CouchDbSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public CouchDbSourceBuilder edit(CouchDbSource item) {
    return new CouchDbSourceBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, CouchDbSource item, boolean dryRun) {
    return new CouchDbSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, CouchDbSource item, Watcher<CouchDbSource> watcher) {
    return new CouchDbSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, CouchDbSource item, String resourceVersion, Watcher<CouchDbSource> watcher) {
    return new CouchDbSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, CouchDbSource item, ListOptions listOptions, Watcher<CouchDbSource> watcher) {
    return new CouchDbSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(listOptions, watcher);
  }

  @Override
  public CouchDbSource waitUntilReady(OkHttpClient client, Config config, String namespace, CouchDbSource item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new CouchDbSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public CouchDbSource waitUntilCondition(OkHttpClient client, Config config, String namespace, CouchDbSource item, Predicate<CouchDbSource> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new CouchDbSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
