

                        
      
package io.fabric8.knative.client.messaging.v1.internal;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.knative.messaging.v1.Channel;
import io.fabric8.knative.messaging.v1.ChannelBuilder;
import io.fabric8.knative.messaging.v1.ChannelList;

import java.util.Map;
import java.util.TreeMap;


public class ChannelOperationsImpl extends HasMetadataOperation<Channel, ChannelList, Resource<Channel>> {

  public ChannelOperationsImpl(OkHttpClient client, Config config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public ChannelOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("messaging.knative.dev")
    .withApiGroupVersion("v1")
    .withPlural("channels"));
    this.type = Channel.class;
    this.listType = ChannelList.class;
  }

  public ChannelOperationsImpl newInstance(OperationContext context) {
    return new ChannelOperationsImpl(context);
  }

  @Override
  public Channel edit(Visitor... visitors) {
    return patch(new ChannelBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
