

                        

package io.fabric8.knative.client.eventing.v1alpha1.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.knative.client.eventing.v1alpha1.internal.GitHubSourceOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.knative.eventing.contrib.github.v1alpha1.GitHubSource;
import io.fabric8.knative.eventing.contrib.github.v1alpha1.GitHubSourceBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class GitHubSourceHandler implements ResourceHandler<GitHubSource, GitHubSourceBuilder> {

  @Override
  public String getKind() {
    return GitHubSource.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "sources.knative.dev/v1alpha1";
      }

  @Override
  public GitHubSource create(OkHttpClient client, Config config, String namespace, GitHubSource item, boolean dryRun) {
    return new GitHubSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public GitHubSource replace(OkHttpClient client, Config config, String namespace, GitHubSource item, boolean dryRun) {
    return new GitHubSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public GitHubSource reload(OkHttpClient client, Config config, String namespace, GitHubSource item) {
    return new GitHubSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public GitHubSourceBuilder edit(GitHubSource item) {
    return new GitHubSourceBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, GitHubSource item, boolean dryRun) {
    return new GitHubSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, GitHubSource item, Watcher<GitHubSource> watcher) {
    return new GitHubSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, GitHubSource item, String resourceVersion, Watcher<GitHubSource> watcher) {
    return new GitHubSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, GitHubSource item, ListOptions listOptions, Watcher<GitHubSource> watcher) {
    return new GitHubSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(listOptions, watcher);
  }

  @Override
  public GitHubSource waitUntilReady(OkHttpClient client, Config config, String namespace, GitHubSource item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new GitHubSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public GitHubSource waitUntilCondition(OkHttpClient client, Config config, String namespace, GitHubSource item, Predicate<GitHubSource> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new GitHubSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
