

                        
      
package io.fabric8.knative.client.flows.v1.internal;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.knative.flows.v1.Parallel;
import io.fabric8.knative.flows.v1.ParallelBuilder;
import io.fabric8.knative.flows.v1.ParallelList;

import java.util.Map;
import java.util.TreeMap;


public class ParallelOperationsImpl extends HasMetadataOperation<Parallel, ParallelList, Resource<Parallel>> {

  public ParallelOperationsImpl(OkHttpClient client, Config config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public ParallelOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("flows.knative.dev")
    .withApiGroupVersion("v1")
    .withPlural("parallels"));
    this.type = Parallel.class;
    this.listType = ParallelList.class;
  }

  public ParallelOperationsImpl newInstance(OperationContext context) {
    return new ParallelOperationsImpl(context);
  }

  @Override
  public Parallel edit(Visitor... visitors) {
    return patch(new ParallelBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
