

                        

package io.fabric8.knative.client.sources.v1.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.knative.client.sources.v1.internal.PingSourceOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.knative.sources.v1.PingSource;
import io.fabric8.knative.sources.v1.PingSourceBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class PingSourceHandler implements ResourceHandler<PingSource, PingSourceBuilder> {

  @Override
  public String getKind() {
    return PingSource.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "sources.knative.dev/v1";
      }

  @Override
  public PingSource create(OkHttpClient client, Config config, String namespace, PingSource item, boolean dryRun) {
    return new PingSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public PingSource replace(OkHttpClient client, Config config, String namespace, PingSource item, boolean dryRun) {
    return new PingSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public PingSource reload(OkHttpClient client, Config config, String namespace, PingSource item) {
    return new PingSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public PingSourceBuilder edit(PingSource item) {
    return new PingSourceBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, PingSource item, boolean dryRun) {
    return new PingSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, PingSource item, Watcher<PingSource> watcher) {
    return new PingSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, PingSource item, String resourceVersion, Watcher<PingSource> watcher) {
    return new PingSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, PingSource item, ListOptions listOptions, Watcher<PingSource> watcher) {
    return new PingSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(listOptions, watcher);
  }

  @Override
  public PingSource waitUntilReady(OkHttpClient client, Config config, String namespace, PingSource item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new PingSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public PingSource waitUntilCondition(OkHttpClient client, Config config, String namespace, PingSource item, Predicate<PingSource> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new PingSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
