

                        

package io.fabric8.knative.client.eventing.v1.handlers;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.knative.client.eventing.v1.internal.BrokerOperationsImpl;

import okhttp3.OkHttpClient;

import io.fabric8.knative.eventing.v1.Broker;
import io.fabric8.knative.eventing.v1.BrokerBuilder;

public class BrokerHandler implements ResourceHandler<Broker, BrokerBuilder> {

  @Override
  public String getKind() {
    return Broker.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "eventing.knative.dev/v1";
      }

  @Override
  public BrokerBuilder edit(Broker item) {
    return new BrokerBuilder(item);
  }
  
  @Override
  public Resource<Broker> resource(OkHttpClient client, Config config, String namespace, Broker item) {
    return new BrokerOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
