

                        

package io.fabric8.knative.client.eventing.v1.handlers;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.knative.client.eventing.v1.internal.TriggerOperationsImpl;

import okhttp3.OkHttpClient;

import io.fabric8.knative.eventing.v1.Trigger;
import io.fabric8.knative.eventing.v1.TriggerBuilder;

public class TriggerHandler implements ResourceHandler<Trigger, TriggerBuilder> {

  @Override
  public String getKind() {
    return Trigger.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "eventing.knative.dev/v1";
      }

  @Override
  public TriggerBuilder edit(Trigger item) {
    return new TriggerBuilder(item);
  }
  
  @Override
  public Resource<Trigger> resource(OkHttpClient client, Config config, String namespace, Trigger item) {
    return new TriggerOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
