

                        

package io.fabric8.knative.client.eventing.v1alpha1.handlers;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.knative.client.eventing.v1alpha1.internal.AwsSqsSourceOperationsImpl;

import okhttp3.OkHttpClient;

import io.fabric8.knative.eventing.contrib.awssqs.v1alpha1.AwsSqsSource;
import io.fabric8.knative.eventing.contrib.awssqs.v1alpha1.AwsSqsSourceBuilder;

public class AwsSqsSourceHandler implements ResourceHandler<AwsSqsSource, AwsSqsSourceBuilder> {

  @Override
  public String getKind() {
    return AwsSqsSource.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "sources.knative.dev/v1alpha1";
      }

  @Override
  public AwsSqsSourceBuilder edit(AwsSqsSource item) {
    return new AwsSqsSourceBuilder(item);
  }
  
  @Override
  public Resource<AwsSqsSource> resource(OkHttpClient client, Config config, String namespace, AwsSqsSource item) {
    return new AwsSqsSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
