

                        

package io.fabric8.knative.client.eventing.v1alpha1.handlers;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.knative.client.eventing.v1alpha1.internal.CouchDbSourceOperationsImpl;

import okhttp3.OkHttpClient;

import io.fabric8.knative.eventing.contrib.couchdb.v1alpha1.CouchDbSource;
import io.fabric8.knative.eventing.contrib.couchdb.v1alpha1.CouchDbSourceBuilder;

public class CouchDbSourceHandler implements ResourceHandler<CouchDbSource, CouchDbSourceBuilder> {

  @Override
  public String getKind() {
    return CouchDbSource.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "sources.knative.dev/v1alpha1";
      }

  @Override
  public CouchDbSourceBuilder edit(CouchDbSource item) {
    return new CouchDbSourceBuilder(item);
  }
  
  @Override
  public Resource<CouchDbSource> resource(OkHttpClient client, Config config, String namespace, CouchDbSource item) {
    return new CouchDbSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
