

                        

package io.fabric8.knative.client.eventing.v1alpha1.handlers;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.knative.client.eventing.v1alpha1.internal.GitHubBindingOperationsImpl;

import okhttp3.OkHttpClient;

import io.fabric8.knative.eventing.contrib.github.v1alpha1.GitHubBinding;
import io.fabric8.knative.eventing.contrib.github.v1alpha1.GitHubBindingBuilder;

public class GitHubBindingHandler implements ResourceHandler<GitHubBinding, GitHubBindingBuilder> {

  @Override
  public String getKind() {
    return GitHubBinding.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "bindings.knative.dev/v1alpha1";
      }

  @Override
  public GitHubBindingBuilder edit(GitHubBinding item) {
    return new GitHubBindingBuilder(item);
  }
  
  @Override
  public Resource<GitHubBinding> resource(OkHttpClient client, Config config, String namespace, GitHubBinding item) {
    return new GitHubBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
