

                        

package io.fabric8.knative.client.eventing.v1alpha1.handlers;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.knative.client.eventing.v1alpha1.internal.GitHubSourceOperationsImpl;

import okhttp3.OkHttpClient;

import io.fabric8.knative.eventing.contrib.github.v1alpha1.GitHubSource;
import io.fabric8.knative.eventing.contrib.github.v1alpha1.GitHubSourceBuilder;

public class GitHubSourceHandler implements ResourceHandler<GitHubSource, GitHubSourceBuilder> {

  @Override
  public String getKind() {
    return GitHubSource.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "sources.knative.dev/v1alpha1";
      }

  @Override
  public GitHubSourceBuilder edit(GitHubSource item) {
    return new GitHubSourceBuilder(item);
  }
  
  @Override
  public Resource<GitHubSource> resource(OkHttpClient client, Config config, String namespace, GitHubSource item) {
    return new GitHubSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
