

                        

package io.fabric8.knative.client.eventing.v1alpha1.handlers;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.knative.client.eventing.v1alpha1.internal.GitLabBindingOperationsImpl;

import okhttp3.OkHttpClient;

import io.fabric8.knative.eventing.contrib.gitlab.v1alpha1.GitLabBinding;
import io.fabric8.knative.eventing.contrib.gitlab.v1alpha1.GitLabBindingBuilder;

public class GitLabBindingHandler implements ResourceHandler<GitLabBinding, GitLabBindingBuilder> {

  @Override
  public String getKind() {
    return GitLabBinding.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "bindings.knative.dev/v1alpha1";
      }

  @Override
  public GitLabBindingBuilder edit(GitLabBinding item) {
    return new GitLabBindingBuilder(item);
  }
  
  @Override
  public Resource<GitLabBinding> resource(OkHttpClient client, Config config, String namespace, GitLabBinding item) {
    return new GitLabBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
