

                        

package io.fabric8.knative.client.eventing.v1alpha1.handlers;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.knative.client.eventing.v1alpha1.internal.GitLabSourceOperationsImpl;

import okhttp3.OkHttpClient;

import io.fabric8.knative.eventing.contrib.gitlab.v1alpha1.GitLabSource;
import io.fabric8.knative.eventing.contrib.gitlab.v1alpha1.GitLabSourceBuilder;

public class GitLabSourceHandler implements ResourceHandler<GitLabSource, GitLabSourceBuilder> {

  @Override
  public String getKind() {
    return GitLabSource.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "sources.knative.dev/v1alpha1";
      }

  @Override
  public GitLabSourceBuilder edit(GitLabSource item) {
    return new GitLabSourceBuilder(item);
  }
  
  @Override
  public Resource<GitLabSource> resource(OkHttpClient client, Config config, String namespace, GitLabSource item) {
    return new GitLabSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
