

                        

package io.fabric8.knative.client.eventing.v1alpha1.handlers;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.knative.client.eventing.v1alpha1.internal.PrometheusSourceOperationsImpl;

import okhttp3.OkHttpClient;

import io.fabric8.knative.eventing.contrib.prometheus.v1alpha1.PrometheusSource;
import io.fabric8.knative.eventing.contrib.prometheus.v1alpha1.PrometheusSourceBuilder;

public class PrometheusSourceHandler implements ResourceHandler<PrometheusSource, PrometheusSourceBuilder> {

  @Override
  public String getKind() {
    return PrometheusSource.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "sources.knative.dev/v1alpha1";
      }

  @Override
  public PrometheusSourceBuilder edit(PrometheusSource item) {
    return new PrometheusSourceBuilder(item);
  }
  
  @Override
  public Resource<PrometheusSource> resource(OkHttpClient client, Config config, String namespace, PrometheusSource item) {
    return new PrometheusSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
