

                        

package io.fabric8.knative.client.eventing.v1beta1.handlers;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.knative.client.eventing.v1beta1.internal.EventTypeOperationsImpl;

import okhttp3.OkHttpClient;

import io.fabric8.knative.eventing.v1beta1.EventType;
import io.fabric8.knative.eventing.v1beta1.EventTypeBuilder;

public class EventTypeHandler implements ResourceHandler<EventType, EventTypeBuilder> {

  @Override
  public String getKind() {
    return EventType.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "eventing.knative.dev/v1beta1";
      }

  @Override
  public EventTypeBuilder edit(EventType item) {
    return new EventTypeBuilder(item);
  }
  
  @Override
  public Resource<EventType> resource(OkHttpClient client, Config config, String namespace, EventType item) {
    return new EventTypeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
