

                        

package io.fabric8.knative.client.eventing.v1beta1.handlers;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.knative.client.eventing.v1beta1.internal.KafkaBindingOperationsImpl;

import okhttp3.OkHttpClient;

import io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaBinding;
import io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaBindingBuilder;

public class KafkaBindingHandler implements ResourceHandler<KafkaBinding, KafkaBindingBuilder> {

  @Override
  public String getKind() {
    return KafkaBinding.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "bindings.knative.dev/v1beta1";
      }

  @Override
  public KafkaBindingBuilder edit(KafkaBinding item) {
    return new KafkaBindingBuilder(item);
  }
  
  @Override
  public Resource<KafkaBinding> resource(OkHttpClient client, Config config, String namespace, KafkaBinding item) {
    return new KafkaBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
