

                        

package io.fabric8.knative.client.eventing.v1beta1.handlers;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.knative.client.eventing.v1beta1.internal.KafkaChannelOperationsImpl;

import okhttp3.OkHttpClient;

import io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaChannel;
import io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaChannelBuilder;

public class KafkaChannelHandler implements ResourceHandler<KafkaChannel, KafkaChannelBuilder> {

  @Override
  public String getKind() {
    return KafkaChannel.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "messaging.knative.dev/v1beta1";
      }

  @Override
  public KafkaChannelBuilder edit(KafkaChannel item) {
    return new KafkaChannelBuilder(item);
  }
  
  @Override
  public Resource<KafkaChannel> resource(OkHttpClient client, Config config, String namespace, KafkaChannel item) {
    return new KafkaChannelOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
