

                        

package io.fabric8.knative.client.eventing.v1beta1.handlers;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.knative.client.eventing.v1beta1.internal.KafkaSourceOperationsImpl;

import okhttp3.OkHttpClient;

import io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSource;
import io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceBuilder;

public class KafkaSourceHandler implements ResourceHandler<KafkaSource, KafkaSourceBuilder> {

  @Override
  public String getKind() {
    return KafkaSource.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "sources.knative.dev/v1beta1";
      }

  @Override
  public KafkaSourceBuilder edit(KafkaSource item) {
    return new KafkaSourceBuilder(item);
  }
  
  @Override
  public Resource<KafkaSource> resource(OkHttpClient client, Config config, String namespace, KafkaSource item) {
    return new KafkaSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
