

                        

package io.fabric8.knative.client.flows.v1.handlers;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.knative.client.flows.v1.internal.ParallelOperationsImpl;

import okhttp3.OkHttpClient;

import io.fabric8.knative.flows.v1.Parallel;
import io.fabric8.knative.flows.v1.ParallelBuilder;

public class ParallelHandler implements ResourceHandler<Parallel, ParallelBuilder> {

  @Override
  public String getKind() {
    return Parallel.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "flows.knative.dev/v1";
      }

  @Override
  public ParallelBuilder edit(Parallel item) {
    return new ParallelBuilder(item);
  }
  
  @Override
  public Resource<Parallel> resource(OkHttpClient client, Config config, String namespace, Parallel item) {
    return new ParallelOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
