

                        

package io.fabric8.knative.client.flows.v1.handlers;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.knative.client.flows.v1.internal.SequenceOperationsImpl;

import okhttp3.OkHttpClient;

import io.fabric8.knative.flows.v1.Sequence;
import io.fabric8.knative.flows.v1.SequenceBuilder;

public class SequenceHandler implements ResourceHandler<Sequence, SequenceBuilder> {

  @Override
  public String getKind() {
    return Sequence.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "flows.knative.dev/v1";
      }

  @Override
  public SequenceBuilder edit(Sequence item) {
    return new SequenceBuilder(item);
  }
  
  @Override
  public Resource<Sequence> resource(OkHttpClient client, Config config, String namespace, Sequence item) {
    return new SequenceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
