

                        

package io.fabric8.knative.client.messaging.v1.handlers;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.knative.client.messaging.v1.internal.ChannelOperationsImpl;

import okhttp3.OkHttpClient;

import io.fabric8.knative.messaging.v1.Channel;
import io.fabric8.knative.messaging.v1.ChannelBuilder;

public class ChannelHandler implements ResourceHandler<Channel, ChannelBuilder> {

  @Override
  public String getKind() {
    return Channel.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "messaging.knative.dev/v1";
      }

  @Override
  public ChannelBuilder edit(Channel item) {
    return new ChannelBuilder(item);
  }
  
  @Override
  public Resource<Channel> resource(OkHttpClient client, Config config, String namespace, Channel item) {
    return new ChannelOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
