

                        

package io.fabric8.knative.client.messaging.v1.handlers;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.knative.client.messaging.v1.internal.InMemoryChannelOperationsImpl;

import okhttp3.OkHttpClient;

import io.fabric8.knative.messaging.v1.InMemoryChannel;
import io.fabric8.knative.messaging.v1.InMemoryChannelBuilder;

public class InMemoryChannelHandler implements ResourceHandler<InMemoryChannel, InMemoryChannelBuilder> {

  @Override
  public String getKind() {
    return InMemoryChannel.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "messaging.knative.dev/v1";
      }

  @Override
  public InMemoryChannelBuilder edit(InMemoryChannel item) {
    return new InMemoryChannelBuilder(item);
  }
  
  @Override
  public Resource<InMemoryChannel> resource(OkHttpClient client, Config config, String namespace, InMemoryChannel item) {
    return new InMemoryChannelOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
