

                        

package io.fabric8.knative.client.messaging.v1.handlers;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.knative.client.messaging.v1.internal.SubscriptionOperationsImpl;

import okhttp3.OkHttpClient;

import io.fabric8.knative.messaging.v1.Subscription;
import io.fabric8.knative.messaging.v1.SubscriptionBuilder;

public class SubscriptionHandler implements ResourceHandler<Subscription, SubscriptionBuilder> {

  @Override
  public String getKind() {
    return Subscription.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "messaging.knative.dev/v1";
      }

  @Override
  public SubscriptionBuilder edit(Subscription item) {
    return new SubscriptionBuilder(item);
  }
  
  @Override
  public Resource<Subscription> resource(OkHttpClient client, Config config, String namespace, Subscription item) {
    return new SubscriptionOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
