

                        
      
package io.fabric8.knative.client.messaging.v1.internal;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.knative.messaging.v1.Subscription;
import io.fabric8.knative.messaging.v1.SubscriptionBuilder;
import io.fabric8.knative.messaging.v1.SubscriptionList;

import java.util.Map;
import java.util.TreeMap;


public class SubscriptionOperationsImpl extends HasMetadataOperation<Subscription, SubscriptionList, Resource<Subscription>> {

  public SubscriptionOperationsImpl(OkHttpClient client, Config config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public SubscriptionOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("messaging.knative.dev")
    .withApiGroupVersion("v1")
    .withPlural("subscriptions"));
    this.type = Subscription.class;
    this.listType = SubscriptionList.class;
  }

  public SubscriptionOperationsImpl newInstance(OperationContext context) {
    return new SubscriptionOperationsImpl(context);
  }

  @Override
  public Subscription edit(Visitor... visitors) {
    return patch(new SubscriptionBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
