

                        

package io.fabric8.knative.client.serving.v1.handlers;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.knative.client.serving.v1.internal.ConfigurationOperationsImpl;

import okhttp3.OkHttpClient;

import io.fabric8.knative.serving.v1.Configuration;
import io.fabric8.knative.serving.v1.ConfigurationBuilder;

public class ConfigurationHandler implements ResourceHandler<Configuration, ConfigurationBuilder> {

  @Override
  public String getKind() {
    return Configuration.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "serving.knative.dev/v1";
      }

  @Override
  public ConfigurationBuilder edit(Configuration item) {
    return new ConfigurationBuilder(item);
  }
  
  @Override
  public Resource<Configuration> resource(OkHttpClient client, Config config, String namespace, Configuration item) {
    return new ConfigurationOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
