

                        

package io.fabric8.knative.client.serving.v1.handlers;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.knative.client.serving.v1.internal.RevisionOperationsImpl;

import okhttp3.OkHttpClient;

import io.fabric8.knative.serving.v1.Revision;
import io.fabric8.knative.serving.v1.RevisionBuilder;

public class RevisionHandler implements ResourceHandler<Revision, RevisionBuilder> {

  @Override
  public String getKind() {
    return Revision.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "serving.knative.dev/v1";
      }

  @Override
  public RevisionBuilder edit(Revision item) {
    return new RevisionBuilder(item);
  }
  
  @Override
  public Resource<Revision> resource(OkHttpClient client, Config config, String namespace, Revision item) {
    return new RevisionOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
