

                        

package io.fabric8.knative.client.serving.v1.handlers;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.knative.client.serving.v1.internal.RouteOperationsImpl;

import okhttp3.OkHttpClient;

import io.fabric8.knative.serving.v1.Route;
import io.fabric8.knative.serving.v1.RouteBuilder;

public class RouteHandler implements ResourceHandler<Route, RouteBuilder> {

  @Override
  public String getKind() {
    return Route.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "serving.knative.dev/v1";
      }

  @Override
  public RouteBuilder edit(Route item) {
    return new RouteBuilder(item);
  }
  
  @Override
  public Resource<Route> resource(OkHttpClient client, Config config, String namespace, Route item) {
    return new RouteOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
