

                        

package io.fabric8.knative.client.serving.v1.handlers;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.knative.client.serving.v1.internal.ServiceOperationsImpl;

import okhttp3.OkHttpClient;

import io.fabric8.knative.serving.v1.Service;
import io.fabric8.knative.serving.v1.ServiceBuilder;

public class ServiceHandler implements ResourceHandler<Service, ServiceBuilder> {

  @Override
  public String getKind() {
    return Service.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "serving.knative.dev/v1";
      }

  @Override
  public ServiceBuilder edit(Service item) {
    return new ServiceBuilder(item);
  }
  
  @Override
  public Resource<Service> resource(OkHttpClient client, Config config, String namespace, Service item) {
    return new ServiceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
