

                        

package io.fabric8.knative.client.sources.v1.handlers;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.knative.client.sources.v1.internal.ApiServerSourceOperationsImpl;

import okhttp3.OkHttpClient;

import io.fabric8.knative.sources.v1.ApiServerSource;
import io.fabric8.knative.sources.v1.ApiServerSourceBuilder;

public class ApiServerSourceHandler implements ResourceHandler<ApiServerSource, ApiServerSourceBuilder> {

  @Override
  public String getKind() {
    return ApiServerSource.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "sources.knative.dev/v1";
      }

  @Override
  public ApiServerSourceBuilder edit(ApiServerSource item) {
    return new ApiServerSourceBuilder(item);
  }
  
  @Override
  public Resource<ApiServerSource> resource(OkHttpClient client, Config config, String namespace, ApiServerSource item) {
    return new ApiServerSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
