

                        

package io.fabric8.knative.client.sources.v1.handlers;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.knative.client.sources.v1.internal.ContainerSourceOperationsImpl;

import okhttp3.OkHttpClient;

import io.fabric8.knative.sources.v1.ContainerSource;
import io.fabric8.knative.sources.v1.ContainerSourceBuilder;

public class ContainerSourceHandler implements ResourceHandler<ContainerSource, ContainerSourceBuilder> {

  @Override
  public String getKind() {
    return ContainerSource.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "sources.knative.dev/v1";
      }

  @Override
  public ContainerSourceBuilder edit(ContainerSource item) {
    return new ContainerSourceBuilder(item);
  }
  
  @Override
  public Resource<ContainerSource> resource(OkHttpClient client, Config config, String namespace, ContainerSource item) {
    return new ContainerSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
