

                        

package io.fabric8.knative.client.sources.v1.handlers;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.knative.client.sources.v1.internal.PingSourceOperationsImpl;

import okhttp3.OkHttpClient;

import io.fabric8.knative.sources.v1.PingSource;
import io.fabric8.knative.sources.v1.PingSourceBuilder;

public class PingSourceHandler implements ResourceHandler<PingSource, PingSourceBuilder> {

  @Override
  public String getKind() {
    return PingSource.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "sources.knative.dev/v1";
      }

  @Override
  public PingSourceBuilder edit(PingSource item) {
    return new PingSourceBuilder(item);
  }
  
  @Override
  public Resource<PingSource> resource(OkHttpClient client, Config config, String namespace, PingSource item) {
    return new PingSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
