

                        

package io.fabric8.knative.client.sources.v1.handlers;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.knative.client.sources.v1.internal.SinkBindingOperationsImpl;

import okhttp3.OkHttpClient;

import io.fabric8.knative.sources.v1.SinkBinding;
import io.fabric8.knative.sources.v1.SinkBindingBuilder;

public class SinkBindingHandler implements ResourceHandler<SinkBinding, SinkBindingBuilder> {

  @Override
  public String getKind() {
    return SinkBinding.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "sources.knative.dev/v1";
      }

  @Override
  public SinkBindingBuilder edit(SinkBinding item) {
    return new SinkBindingBuilder(item);
  }
  
  @Override
  public Resource<SinkBinding> resource(OkHttpClient client, Config config, String namespace, SinkBinding item) {
    return new SinkBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName());
  }

}
