

                        
      
package io.fabric8.knative.client.sources.v1.internal;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.knative.sources.v1.ContainerSource;
import io.fabric8.knative.sources.v1.ContainerSourceBuilder;
import io.fabric8.knative.sources.v1.ContainerSourceList;

import java.util.Map;
import java.util.TreeMap;


public class ContainerSourceOperationsImpl extends HasMetadataOperation<ContainerSource, ContainerSourceList, Resource<ContainerSource>> {

  public ContainerSourceOperationsImpl(OkHttpClient client, Config config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public ContainerSourceOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("sources.knative.dev")
    .withApiGroupVersion("v1")
    .withPlural("containersources"));
    this.type = ContainerSource.class;
    this.listType = ContainerSourceList.class;
  }

  public ContainerSourceOperationsImpl newInstance(OperationContext context) {
    return new ContainerSourceOperationsImpl(context);
  }

  @Override
  public ContainerSource edit(Visitor... visitors) {
    return patch(new ContainerSourceBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
