

                        
      
package io.fabric8.knative.client.sources.v1.internal;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.knative.sources.v1.SinkBinding;
import io.fabric8.knative.sources.v1.SinkBindingBuilder;
import io.fabric8.knative.sources.v1.SinkBindingList;

import java.util.Map;
import java.util.TreeMap;


public class SinkBindingOperationsImpl extends HasMetadataOperation<SinkBinding, SinkBindingList, Resource<SinkBinding>> {

  public SinkBindingOperationsImpl(OkHttpClient client, Config config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public SinkBindingOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("sources.knative.dev")
    .withApiGroupVersion("v1")
    .withPlural("sinkbindings"));
    this.type = SinkBinding.class;
    this.listType = SinkBindingList.class;
  }

  public SinkBindingOperationsImpl newInstance(OperationContext context) {
    return new SinkBindingOperationsImpl(context);
  }

  @Override
  public SinkBinding edit(Visitor... visitors) {
    return patch(new SinkBindingBuilder(getMandatory()).accept(visitors).build());
  }
 
  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
