/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.mock;

import io.fabric8.knative.client.KnativeClient;
import io.fabric8.knative.mock.KnativeMockServer;
import io.fabric8.kubernetes.client.server.mock.KubernetesCrudDispatcher;
import io.fabric8.mockwebserver.Context;
import io.fabric8.mockwebserver.ServerRequest;
import io.fabric8.mockwebserver.ServerResponse;
import io.fabric8.mockwebserver.dsl.MockServerExpectation;
import io.fabric8.mockwebserver.dsl.ReturnOrWebsocketable;
import io.fabric8.mockwebserver.dsl.TimesOnceableOrHttpHeaderable;
import java.util.HashMap;
import java.util.Queue;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockWebServer;
import org.junit.rules.ExternalResource;

public class KnativeServer
extends ExternalResource {
    protected KnativeMockServer mock;
    private KnativeClient client;
    private boolean https;
    private boolean crudMode;

    public KnativeServer() {
        this(true, false);
    }

    public KnativeServer(boolean https) {
        this(https, false);
    }

    public KnativeServer(boolean https, boolean crudMode) {
        this.https = https;
        this.crudMode = crudMode;
    }

    public void before() {
        this.mock = this.crudMode ? new KnativeMockServer(new Context(), new MockWebServer(), new HashMap<ServerRequest, Queue<ServerResponse>>(), (Dispatcher)new KubernetesCrudDispatcher(), true) : new KnativeMockServer(this.https);
        this.mock.init();
        this.client = this.mock.createKnative();
    }

    public void after() {
        this.mock.destroy();
        this.client.close();
    }

    public KnativeClient getKnativeClient() {
        return this.client;
    }

    public MockServerExpectation expect() {
        return this.mock.expect();
    }

    @Deprecated
    public <T> void expectAndReturnAsJson(String path, int code, T body) {
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)this.expect().withPath(path)).andReturn(code, body)).always();
    }

    @Deprecated
    public void expectAndReturnAsString(String path, int code, String body) {
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)this.expect().withPath(path)).andReturn(code, (Object)body)).always();
    }

    public MockWebServer getMockServer() {
        return this.mock.getServer();
    }
}

