package io.fabric8.knative.duck.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SubscribableTypeStatusBuilder extends SubscribableTypeStatusFluentImpl<SubscribableTypeStatusBuilder> implements VisitableBuilder<SubscribableTypeStatus,SubscribableTypeStatusBuilder>{

    SubscribableTypeStatusFluent<?> fluent;
    Boolean validationEnabled;

    public SubscribableTypeStatusBuilder(){
            this(true);
    }
    public SubscribableTypeStatusBuilder(Boolean validationEnabled){
            this(new SubscribableTypeStatus(), validationEnabled);
    }
    public SubscribableTypeStatusBuilder(SubscribableTypeStatusFluent<?> fluent){
            this(fluent, true);
    }
    public SubscribableTypeStatusBuilder(SubscribableTypeStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new SubscribableTypeStatus(), validationEnabled);
    }
    public SubscribableTypeStatusBuilder(SubscribableTypeStatusFluent<?> fluent,SubscribableTypeStatus instance){
            this(fluent, instance, true);
    }
    public SubscribableTypeStatusBuilder(SubscribableTypeStatusFluent<?> fluent,SubscribableTypeStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withSubscribableStatus(instance.getSubscribableStatus()); 
            this.validationEnabled = validationEnabled; 
    }
    public SubscribableTypeStatusBuilder(SubscribableTypeStatus instance){
            this(instance,true);
    }
    public SubscribableTypeStatusBuilder(SubscribableTypeStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withSubscribableStatus(instance.getSubscribableStatus()); 
            this.validationEnabled = validationEnabled; 
    }

    public SubscribableTypeStatus build(){
            SubscribableTypeStatus buildable = new SubscribableTypeStatus(fluent.getSubscribableStatus());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SubscribableTypeStatusBuilder that = (SubscribableTypeStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
