package io.fabric8.knative.duck.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;

public class ChannelableSpecFluentImpl<A extends io.fabric8.knative.duck.v1beta1.ChannelableSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.knative.duck.v1beta1.ChannelableSpecFluent<A>{

    private io.fabric8.knative.duck.v1beta1.DeliverySpecBuilder delivery;
    private List<io.fabric8.knative.duck.v1beta1.SubscriberSpecBuilder> subscribers;

    public ChannelableSpecFluentImpl(){
    }
    public ChannelableSpecFluentImpl(io.fabric8.knative.duck.v1beta1.ChannelableSpec instance){
            this.withDelivery(instance.getDelivery()); 
            this.withSubscribers(instance.getSubscribers()); 
    }

    
/**
 * This method has been deprecated, please use method buildDelivery instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public io.fabric8.knative.duck.v1beta1.DeliverySpec getDelivery(){
            return this.delivery!=null?this.delivery.build():null;
    }

    public io.fabric8.knative.duck.v1beta1.DeliverySpec buildDelivery(){
            return this.delivery!=null?this.delivery.build():null;
    }

    public A withDelivery(io.fabric8.knative.duck.v1beta1.DeliverySpec delivery){
            _visitables.get("delivery").remove(this.delivery);
            if (delivery!=null){ this.delivery= new io.fabric8.knative.duck.v1beta1.DeliverySpecBuilder(delivery); _visitables.get("delivery").add(this.delivery);} return (A) this;
    }

    public Boolean hasDelivery(){
            return this.delivery != null;
    }

    public ChannelableSpecFluent.DeliveryNested<A> withNewDelivery(){
            return new DeliveryNestedImpl();
    }

    public ChannelableSpecFluent.DeliveryNested<A> withNewDeliveryLike(io.fabric8.knative.duck.v1beta1.DeliverySpec item){
            return new DeliveryNestedImpl(item);
    }

    public ChannelableSpecFluent.DeliveryNested<A> editDelivery(){
            return withNewDeliveryLike(getDelivery());
    }

    public ChannelableSpecFluent.DeliveryNested<A> editOrNewDelivery(){
            return withNewDeliveryLike(getDelivery() != null ? getDelivery(): new io.fabric8.knative.duck.v1beta1.DeliverySpecBuilder().build());
    }

    public ChannelableSpecFluent.DeliveryNested<A> editOrNewDeliveryLike(io.fabric8.knative.duck.v1beta1.DeliverySpec item){
            return withNewDeliveryLike(getDelivery() != null ? getDelivery(): item);
    }

    public A addToSubscribers(int index,io.fabric8.knative.duck.v1beta1.SubscriberSpec item){
            if (this.subscribers == null) {this.subscribers = new ArrayList<io.fabric8.knative.duck.v1beta1.SubscriberSpecBuilder>();}
            io.fabric8.knative.duck.v1beta1.SubscriberSpecBuilder builder = new io.fabric8.knative.duck.v1beta1.SubscriberSpecBuilder(item);_visitables.get("subscribers").add(index >= 0 ? index : _visitables.get("subscribers").size(), builder);this.subscribers.add(index >= 0 ? index : subscribers.size(), builder); return (A)this;
    }

    public A setToSubscribers(int index,io.fabric8.knative.duck.v1beta1.SubscriberSpec item){
            if (this.subscribers == null) {this.subscribers = new ArrayList<io.fabric8.knative.duck.v1beta1.SubscriberSpecBuilder>();}
            io.fabric8.knative.duck.v1beta1.SubscriberSpecBuilder builder = new io.fabric8.knative.duck.v1beta1.SubscriberSpecBuilder(item);
            if (index < 0 || index >= _visitables.get("subscribers").size()) { _visitables.get("subscribers").add(builder); } else { _visitables.get("subscribers").set(index, builder);}
            if (index < 0 || index >= subscribers.size()) { subscribers.add(builder); } else { subscribers.set(index, builder);}
             return (A)this;
    }

    public A addToSubscribers(io.fabric8.knative.duck.v1beta1.SubscriberSpec... items){
            if (this.subscribers == null) {this.subscribers = new ArrayList<io.fabric8.knative.duck.v1beta1.SubscriberSpecBuilder>();}
            for (io.fabric8.knative.duck.v1beta1.SubscriberSpec item : items) {io.fabric8.knative.duck.v1beta1.SubscriberSpecBuilder builder = new io.fabric8.knative.duck.v1beta1.SubscriberSpecBuilder(item);_visitables.get("subscribers").add(builder);this.subscribers.add(builder);} return (A)this;
    }

    public A addAllToSubscribers(Collection<io.fabric8.knative.duck.v1beta1.SubscriberSpec> items){
            if (this.subscribers == null) {this.subscribers = new ArrayList<io.fabric8.knative.duck.v1beta1.SubscriberSpecBuilder>();}
            for (io.fabric8.knative.duck.v1beta1.SubscriberSpec item : items) {io.fabric8.knative.duck.v1beta1.SubscriberSpecBuilder builder = new io.fabric8.knative.duck.v1beta1.SubscriberSpecBuilder(item);_visitables.get("subscribers").add(builder);this.subscribers.add(builder);} return (A)this;
    }

    public A removeFromSubscribers(io.fabric8.knative.duck.v1beta1.SubscriberSpec... items){
            for (io.fabric8.knative.duck.v1beta1.SubscriberSpec item : items) {io.fabric8.knative.duck.v1beta1.SubscriberSpecBuilder builder = new io.fabric8.knative.duck.v1beta1.SubscriberSpecBuilder(item);_visitables.get("subscribers").remove(builder);if (this.subscribers != null) {this.subscribers.remove(builder);}} return (A)this;
    }

    public A removeAllFromSubscribers(Collection<io.fabric8.knative.duck.v1beta1.SubscriberSpec> items){
            for (io.fabric8.knative.duck.v1beta1.SubscriberSpec item : items) {io.fabric8.knative.duck.v1beta1.SubscriberSpecBuilder builder = new io.fabric8.knative.duck.v1beta1.SubscriberSpecBuilder(item);_visitables.get("subscribers").remove(builder);if (this.subscribers != null) {this.subscribers.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromSubscribers(io.fabric8.kubernetes.api.builder.Predicate<io.fabric8.knative.duck.v1beta1.SubscriberSpecBuilder> predicate){
            if (subscribers == null) return (A) this;
            final Iterator<io.fabric8.knative.duck.v1beta1.SubscriberSpecBuilder> each = subscribers.iterator();
            final List visitables = _visitables.get("subscribers");
            while (each.hasNext()) {
              io.fabric8.knative.duck.v1beta1.SubscriberSpecBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildSubscribers instead.
 * @return The buildable object.
 */
@java.lang.Deprecated public List<io.fabric8.knative.duck.v1beta1.SubscriberSpec> getSubscribers(){
            return build(subscribers);
    }

    public List<io.fabric8.knative.duck.v1beta1.SubscriberSpec> buildSubscribers(){
            return build(subscribers);
    }

    public io.fabric8.knative.duck.v1beta1.SubscriberSpec buildSubscriber(int index){
            return this.subscribers.get(index).build();
    }

    public io.fabric8.knative.duck.v1beta1.SubscriberSpec buildFirstSubscriber(){
            return this.subscribers.get(0).build();
    }

    public io.fabric8.knative.duck.v1beta1.SubscriberSpec buildLastSubscriber(){
            return this.subscribers.get(subscribers.size() - 1).build();
    }

    public io.fabric8.knative.duck.v1beta1.SubscriberSpec buildMatchingSubscriber(io.fabric8.kubernetes.api.builder.Predicate<io.fabric8.knative.duck.v1beta1.SubscriberSpecBuilder> predicate){
            for (io.fabric8.knative.duck.v1beta1.SubscriberSpecBuilder item: subscribers) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingSubscriber(io.fabric8.kubernetes.api.builder.Predicate<io.fabric8.knative.duck.v1beta1.SubscriberSpecBuilder> predicate){
            for (io.fabric8.knative.duck.v1beta1.SubscriberSpecBuilder item: subscribers) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withSubscribers(List<io.fabric8.knative.duck.v1beta1.SubscriberSpec> subscribers){
            if (this.subscribers != null) { _visitables.get("subscribers").removeAll(this.subscribers);}
            if (subscribers != null) {this.subscribers = new ArrayList<io.fabric8.knative.duck.v1beta1.SubscriberSpecBuilder>(); for (io.fabric8.knative.duck.v1beta1.SubscriberSpec item : subscribers){this.addToSubscribers(item);}} else { this.subscribers = null;} return (A) this;
    }

    public A withSubscribers(io.fabric8.knative.duck.v1beta1.SubscriberSpec... subscribers){
            if (this.subscribers != null) {this.subscribers.clear();}
            if (subscribers != null) {for (io.fabric8.knative.duck.v1beta1.SubscriberSpec item :subscribers){ this.addToSubscribers(item);}} return (A) this;
    }

    public Boolean hasSubscribers(){
            return subscribers != null && !subscribers.isEmpty();
    }

    public ChannelableSpecFluent.SubscribersNested<A> addNewSubscriber(){
            return new SubscribersNestedImpl();
    }

    public ChannelableSpecFluent.SubscribersNested<A> addNewSubscriberLike(io.fabric8.knative.duck.v1beta1.SubscriberSpec item){
            return new SubscribersNestedImpl(-1, item);
    }

    public ChannelableSpecFluent.SubscribersNested<A> setNewSubscriberLike(int index,io.fabric8.knative.duck.v1beta1.SubscriberSpec item){
            return new SubscribersNestedImpl(index, item);
    }

    public ChannelableSpecFluent.SubscribersNested<A> editSubscriber(int index){
            if (subscribers.size() <= index) throw new RuntimeException("Can't edit subscribers. Index exceeds size.");
            return setNewSubscriberLike(index, buildSubscriber(index));
    }

    public ChannelableSpecFluent.SubscribersNested<A> editFirstSubscriber(){
            if (subscribers.size() == 0) throw new RuntimeException("Can't edit first subscribers. The list is empty.");
            return setNewSubscriberLike(0, buildSubscriber(0));
    }

    public ChannelableSpecFluent.SubscribersNested<A> editLastSubscriber(){
            int index = subscribers.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last subscribers. The list is empty.");
            return setNewSubscriberLike(index, buildSubscriber(index));
    }

    public ChannelableSpecFluent.SubscribersNested<A> editMatchingSubscriber(io.fabric8.kubernetes.api.builder.Predicate<io.fabric8.knative.duck.v1beta1.SubscriberSpecBuilder> predicate){
            int index = -1;
            for (int i=0;i<subscribers.size();i++) { 
            if (predicate.apply(subscribers.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching subscribers. No match found.");
            return setNewSubscriberLike(index, buildSubscriber(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ChannelableSpecFluentImpl that = (ChannelableSpecFluentImpl) o;
            if (delivery != null ? !delivery.equals(that.delivery) :that.delivery != null) return false;
            if (subscribers != null ? !subscribers.equals(that.subscribers) :that.subscribers != null) return false;
            return true;
    }


    public class DeliveryNestedImpl<N> extends io.fabric8.knative.duck.v1beta1.DeliverySpecFluentImpl<ChannelableSpecFluent.DeliveryNested<N>> implements ChannelableSpecFluent.DeliveryNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final io.fabric8.knative.duck.v1beta1.DeliverySpecBuilder builder;
    
            DeliveryNestedImpl(io.fabric8.knative.duck.v1beta1.DeliverySpec item){
                    this.builder = new io.fabric8.knative.duck.v1beta1.DeliverySpecBuilder(this, item);
            }
            DeliveryNestedImpl(){
                    this.builder = new io.fabric8.knative.duck.v1beta1.DeliverySpecBuilder(this);
            }
    
    public N and(){
            return (N) ChannelableSpecFluentImpl.this.withDelivery(builder.build());
    }
    public N endDelivery(){
            return and();
    }

}
    public class SubscribersNestedImpl<N> extends io.fabric8.knative.duck.v1beta1.SubscriberSpecFluentImpl<ChannelableSpecFluent.SubscribersNested<N>> implements ChannelableSpecFluent.SubscribersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final io.fabric8.knative.duck.v1beta1.SubscriberSpecBuilder builder;
        private final int index;
    
            SubscribersNestedImpl(int index,io.fabric8.knative.duck.v1beta1.SubscriberSpec item){
                    this.index = index;
                    this.builder = new io.fabric8.knative.duck.v1beta1.SubscriberSpecBuilder(this, item);
            }
            SubscribersNestedImpl(){
                    this.index = -1;
                    this.builder = new io.fabric8.knative.duck.v1beta1.SubscriberSpecBuilder(this);
            }
    
    public N and(){
            return (N) ChannelableSpecFluentImpl.this.setToSubscribers(index,builder.build());
    }
    public N endSubscriber(){
            return and();
    }

}


}
