package io.fabric8.knative.flows.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ParallelSpecBuilder extends ParallelSpecFluentImpl<ParallelSpecBuilder> implements VisitableBuilder<ParallelSpec,ParallelSpecBuilder>{

    ParallelSpecFluent<?> fluent;
    Boolean validationEnabled;

    public ParallelSpecBuilder(){
            this(true);
    }
    public ParallelSpecBuilder(Boolean validationEnabled){
            this(new ParallelSpec(), validationEnabled);
    }
    public ParallelSpecBuilder(ParallelSpecFluent<?> fluent){
            this(fluent, true);
    }
    public ParallelSpecBuilder(ParallelSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ParallelSpec(), validationEnabled);
    }
    public ParallelSpecBuilder(ParallelSpecFluent<?> fluent,ParallelSpec instance){
            this(fluent, instance, true);
    }
    public ParallelSpecBuilder(ParallelSpecFluent<?> fluent,ParallelSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withBranches(instance.getBranches()); 
            fluent.withChannelTemplate(instance.getChannelTemplate()); 
            fluent.withReply(instance.getReply()); 
            this.validationEnabled = validationEnabled; 
    }
    public ParallelSpecBuilder(ParallelSpec instance){
            this(instance,true);
    }
    public ParallelSpecBuilder(ParallelSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withBranches(instance.getBranches()); 
            this.withChannelTemplate(instance.getChannelTemplate()); 
            this.withReply(instance.getReply()); 
            this.validationEnabled = validationEnabled; 
    }

    public ParallelSpec build(){
            ParallelSpec buildable = new ParallelSpec(fluent.getBranches(),fluent.getChannelTemplate(),fluent.getReply());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ParallelSpecBuilder that = (ParallelSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
